<?php
if (isset($_POST['withdrawal'])) {
    $payment_gateway = $_POST['payment_gateway'];
    $wallet_add = $_POST['wallet_add'];
    $amount = $_POST['amount'];
    $withdraw_from = $_POST['withdraw_from'];

    if (empty($payment_gateway) || empty($wallet_add) || empty($amount) || empty($withdraw_from)) {
        $withdraw_error = "empty";
    }  else if ($withdraw_from == "balance" && $amount > $balance) {
      $withdraw_error = "insufficient_bal";
    }  else if ($withdraw_from == "profit" && $amount > $b_profit) {
      $withdraw_error = "insufficient_profit";
    }  else if ($withdraw_from == "promo" && $amount > $bonus) {
      $withdraw_error = "insufficient_bonus";
    }  else if ($withdraw_from == "bonus" && $amount > $promo) {
      $withdraw_error = "insufficient_promo";
    } else {
        $transaction_status = "pending";
        $transaction_type = "withdrawal";
        $date = date("D. dS m, Y");
        $time = date("h:i a");
        $d_amount = number_format($amount, 2);

        $sql = "INSERT INTO transaction (transaction_user_id, transaction_type, transaction_status, t_mode, transaction_amount, wallet_address, transaction_date) VALUES (?,?,?,?,?,?,?)";
        $stmt = $connection->prepare($sql);
        $stmt->bind_param("sssssss", $user_id, $transaction_type, $transaction_status, $payment_gateway, $amount, $wallet_add, $date);
        if ($stmt->execute()){

          if ($withdraw_from == "balance") {
            $new_balance = $balance - $amount;
              $sql_update = "UPDATE users SET balance = '$new_balance' WHERE user_id = '$user_id'";

          }elseif ($withdraw_from == "profit") {
            $new_balance = $b_profit - $amount;
              $sql_update = "UPDATE users SET profit = '$new_balance' WHERE user_id = '$user_id'";

          }elseif ($withdraw_from == "promo") {
            $new_balance = $promo - $amount;
              $sql_update = "UPDATE users SET promo = '$new_balance' WHERE user_id = '$user_id'";

          }elseif ($withdraw_from == "bonus") {
            $new_balance = $bonus - $amount;
              $sql_update = "UPDATE users SET bonus = '$new_balance' WHERE user_id = '$user_id'";
          }

          if ($connection->query($sql_update) === true) {

            // send mail
                $to = "$email";
                $subject = "Withdrawal Notification";
                $message = "
                <div style='background: #0C0E27; padding: 10px;'>
                <br>
                <center><img src='$website_url/images/$logo_img' width='200px;'></center>
                <br>
                <div style='width: 60%; font-family: sans-serif; padding: 10px 4%; background: white; margin: 5px auto; border-radius: 0px;'>
                <center>
                  <h3>$website_name</h3>
                  <p>Fund withdrawal</p>
                </center>
                <p>
                  Hello $username<br>
                  Your withdrawal of $currency$d_amount is pending, Please wait while the transaction is been process <br>
                  <b>Funds will be disburse to your $payment_gateway wallet address after 3 Network confirmation</b>
                </p>
                <br>
                <hr>
                <p>
                  <b>Transaction Details</b> <br>
                  Amount: <b> <span>$currency</span>$d_amount</b><br>
                  Withdraw Method: <b> $payment_gateway</b><br>
                  Wallet Address: <b> $wallet_add</b><br>
                  Date: <b> $date </b><br>
                  Time: <b> $time</b><br>
                </p>
                <hr>

                <br>
                <center><p>Have a question? <a href='mailto:$website_email' style='color:#000'>$website_email</a></p></center>
                </div><br>
                <center><p style='font-size: 13px; color:#ccc'>©2016-$today <a href='$website_url' style='color:blue'>$website_name</a  All rights reserved.</p></center>
                <br>
                </div>";

                // Always set content-type when sending HTML email
                $headers = "MIME-Version: 1.0" . "\r\n";
                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

                // More headers
                $headers .= "From: $website_name <$website_email>" . "\r\n";
                $headers .= "Reply-To: $website_email \r\n";
                $headers .= "Return-Path: $website_email\r\n";
                // $headers .= "BCC: $website_email\r\n";

                if (mail($to,$subject,$message,$headers,"-f $website_email")){
                  // send mail
                  $to = "$website_email";
                  $subject = "User Withdrawal Request";
                  $message = "
                  <div style='background: #0C0E27; padding: 10px;'>
                  <br>
                  <center><img src='$website_url/images/$logo_img' width='200px;'></center>
                  <br>
                  <div style='width: 60%; font-family: sans-serif; padding: 10px 4%; background: white; margin: 5px auto; border-radius: 0px;'>
                  <p>Hello Admin, a withdrawal just occur on the system.<br>
                  $full_name made a withdraw request of $currency$d_amount</p>
                  <p>
                    <b>Transaction Details</b> <br>
                    Amount: <b> <span>$currency</span>$d_amount</b><br>
                    Withdraw Method: <b> $payment_gateway</b><br>
                    Wallet Address: <b> $wallet_add</b><br>
                    Date: <b> $date </b><br>
                    Time: <b> $time</b><br>
                  </p>

                  <p>Login and confirm this transaction</p>

                  <a href='$website_url' style='color: dodgerblue; text-decoration: none'>
                  <button style='padding: 10px; background: dodgerblue; border: 1px solid transparent; color: white; width: 100%; border-radius: 3px'>Login Now</button></a>
                  </div><br>
                  <center><p style='font-size: 13px; color:#ccc'>©2016-$today <a href='$website_url' style='color:blue'>$website_name</a  All rights reserved.</p></center>
                  <br>
                  </div>";

                  // Always set content-type when sending HTML email
                  $headers = "MIME-Version: 1.0" . "\r\n";
                  $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

                  // More headers
                  $headers .= "From: $website_name <$website_email>" . "\r\n";
                  $headers .= "Reply-To: $website_email \r\n";
                  $headers .= "Return-Path: $website_email\r\n";
                  // $headers .= "BCC: $website_email\r\n";

            if (mail($to, $subject, $message, $headers,"-f $website_email")) {
                  $withdraw_error = "success";
            } else {
              $withdraw_error = "error";
            }
        }
      } else {
          $withdraw_error = "error";
      }
    }else {
        $withdraw_error = "error";
    }
  }
}
?>
<p id="withdraw_error" style='display: none'><?php echo $withdraw_error?></p>
<script>
    var withdraw_error = document.getElementById('withdraw_error');

    if (withdraw_error.textContent == 'empty') {
        swal("ERROR!", "Fill out all field to complete withdrawal", "info");

    }else if (withdraw_error.textContent == "insufficient_bal") {
        swal("INSUFFICIENT!", "No enough funds in your account balance", "warning");

    }else if (withdraw_error.textContent == "insufficient_profit") {
        swal("INSUFFICIENT!", "No enough funds in your profit balance", "warning");

    }else if (withdraw_error.textContent == "insufficient_bonus") {
        swal("INSUFFICIENT!", "No enough funds in your bonus balance", "warning");

    }else if (withdraw_error.textContent == "insufficient_promo") {
        swal("INSUFFICIENT!", "No enough funds in your promo balance", "warning");

    }else if (withdraw_error.textContent == "success") {
      swal("SUCCESS!", "Withdrawal successful, wait while the transaction is been process", "success");
        setTimeout(() => {
            window.location.href = ''
        }, 2000);

    }else if (withdraw_error.textContent == "error") {
        swal("ERROR!", "Sorry an error occurred. Please try again later", "warning");
    }

</script>
