<?php
include('includes/header.php');
include('includes/navbar.php');
?>

<div class="container-fluid">

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary" style="margin-bottom:5px">Investment Packages</h6>
            <a href="add_plan.php" class="btn btn-primary"><i class="fa-solid fa-add"></i> Add New Plan</a>
          </div>
        <?php
        // DELETE USER CARD
        if(isset($_POST['delete_plan_btn']))
        {
            $plan_id = $_POST['delete_plan'];
            $query_delete = "DELETE FROM packages WHERE package_id = '$plan_id'";
            if ($connection->query($query_delete)===TRUE) {
                $error = "delete_success";
            }else {
                $error = "error";
              }
        }
         ?>
        <div class="card-body">
            <div class="table-responsive">
            <?php
                $i=1;
                $query = "SELECT * FROM packages ORDER BY package_id DESC";
                $query_run = mysqli_query($connection, $query);
            ?>
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th> S/N </th>
                            <th> Plan Name </th>
                            <th> Minimum Amount</th>
                            <th> Maximum Amount</th>
                            <th> ROI </th>
                            <th> Duration </th>
                            <th> Referral Bonus </th>
                            <th>Status</th>
                            <th>EDIT</th>
                            <th>DELETE</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if(mysqli_num_rows($query_run) > 0)
                        {
                            while($row = mysqli_fetch_assoc($query_run))
                            {
                        ?>
                            <tr>
                                <td><?php  echo $i++; ?></td>
                                <td><?php  echo $row['package_name']; ?></td>
                                <td><?php echo $currency ?><?php  echo number_format($row['package_min'],2) ?> </td>
                                <td><?php echo $currency ?><?php  echo number_format($row['package_max'],2) ?></td>
                                <td><?php  echo $row['package_interest']; ?>%</td>
                                <td><?php echo $row['duration']; ?> Days</td>
                              <td><?php  echo $row['referral_bonus']; ?>%</td>
                                <td>
                                  <?php
                                    $status = $row['status'];
                                    if ($status == "active"):
                                   ?>
                                   <span style="color: green; font-weight: bold;">Active</span>
                                 <?php elseif ($status == "block"): ?>
                                   <span style="color: red; font-weight: bold;">Blocked</span>
                                 <?php endif; ?>
                                 </td>
                                <td>
                                  <a href="edit_plan.php?plan_id=<?php echo $row['package_id']; ?>" class="btn btn-primary"><i class="fa-solid fa-pen"></i></a>

                                </td>
                                <td>
                                    <form action="" method="post" onsubmit="return(confirm('Delete plan confirmation, Click to proceed'))">
                                        <input type="hidden" name="delete_plan" value="<?php echo $row['package_id']; ?>">
                                        <button type="submit" name="delete_plan_btn" class="btn btn-danger"> <i class="fa-solid fa-trash-can"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php
                            }
                        }
                        else {
                            echo "No Record Found";
                        }
                        ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>



</div>
<!-- /.container-fluid -->
<p id="error" style='display: none '><?php echo $error?></p>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    var error = document.getElementById('error');

    if (error.textContent == "delete_success") {
      swal("Successful!", "Investment plan was deleted successfully", "success");
        setTimeout(() => {
            window.location.href = 'invest_plans.php'
        }, 1500);
    }else if (error.textContent == "block_success") {
      swal("Successful!", "User ATM Card blocked successfully", "success");
        setTimeout(() => {
            window.location.href = 'user_cards.php'
        }, 2000);
    }else if (error.textContent == "error") {
      swal("ERROR!", "Sorry!!!, Something went wrong, try later or contact support", "error");
    }

</script>
<?php
include('includes/scripts.php');
include('includes/footer.php');
?>
