<?php
include('includes/header.php');
include('includes/navbar.php');
?>


<?php
if (isset($_POST['add_plan'])) {
    $plan_id = $_POST['plan_id'];
    $package_name = $_POST['package_name'];
    $package_min = $_POST['package_min'];
    $package_max = $_POST['package_max'];
    $package_interest = $_POST['package_interest'];
    $referral_bonus = $_POST['referral_interest'];
    $duration = $_POST['duration'];
    $status = $_POST['status'];

    if (empty($package_name) || empty($package_min) || empty($package_max) || empty($package_interest) || empty($referral_bonus) ||
     empty($duration) || empty($status)) {
      $plan_error = "empty";
    }else {
      $sql = "INSERT INTO packages (package_name, package_min, package_max, package_interest, referral_bonus, duration, status) VALUES (?,?,?,?,?,?,?)";
      $stmt = $connection->prepare($sql);
      $stmt->bind_param("sssssss", $package_name, $package_min, $package_max, $package_interest, $referral_bonus, $duration, $status);
      if ($stmt->execute()){
          $plan_error = "add_success";
      }else {
        $plan_error = "error";
      }
    }
}
 ?>

<div class="container-fluid">

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Edit Transaction Details</h6>
        </div>
        <div class="card-body">

                        <form action="" method="POST">
                            <div class="form-group">
                                <label> Plan Name </label>
                                <input type="text" name="package_name" value="<?php echo $row['package_name'] ?>" class="form-control">
                            </div>
                            <div class="form-group">
                                <label> Minimum Amount </label>
                                <input type="datetime" name="package_min" value="<?php echo $row['package_min'] ?>" class="form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group">
                                <label> Maximum Amount </label>
                                <input type="datetime" name="package_max" value="<?php echo $row['package_interest'] ?>" class="form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group">
                                <label> Interest Rate (%) </label>
                                <input type="datetime" name="package_interest" value="<?php echo $row['package_interest'] ?>" class="form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group">
                                <label> Referral Bonus (%) </label>
                                <input type="datetime" name="referral_interest" value="<?php echo $row['package_interest'] ?>" class="form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group">
                                <label> Duration (In Days) <small>Duration should be in days, for accuration calculation</small> </label>
                                <input type="datetime" name="duration" value="<?php echo $row['duration'] ?>" class="form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>

                            <div class="form-group">
                                <label>Status</label>
                                <select class="form-control" name="status" style="text-transform:capitalize">
                                    <option value="">--Select Status--</option>
                                    <option value="active">Active</option>
                                    <option value="block">Blocked</option>
                                </select>
                            </div>

                            <a href="invest_plans.php" class="btn btn-danger"> CANCEL </a>
                            <button type="submit" name="add_plan" class="btn btn-primary"> Add Plan </button>

                        </form>
        </div>
    </div>
</div>

</div>

<p id="plan_error" style='display: none'><?php echo $plan_error?></p>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    var plan_error = document.getElementById('plan_error');

    if (plan_error.textContent == 'empty') {
         swal("ERROR!", "Input's cannot be empty!", "warning");
    }else if (plan_error.textContent == "add_success") {
        swal("SUCCESS!", "Plan added Successfully", "success");
        setTimeout(() => {
            window.location.href = 'invest_plans.php'
        }, 1500);
    }else if (plan_error.textContent == "error") {
        swal("ERROR!", "Sorry an error occurred. Please try again later", "warning");
    }

</script>
<?php
include('includes/scripts.php');
include('includes/footer.php');
?>
