<?php
include('includes/header.php');
include('includes/navbar.php');
?>

<!-- Begin Page Content -->
<div class="container-fluid">

  <!-- Page Heading -->
  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
  </div>

  <!-- Content Row -->
  <div class="row">

    <!-- Earnings (Monthly) Card Example -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Registered Users</div>
              <div class="h5 mb-0 font-weight-bold text-gray-800">
              <?php
                $query = "SELECT * FROM users WHERE id != 1 ORDER BY id DESC";
                $query_run = mysqli_query($connection, $query);
                $row = mysqli_num_rows($query_run);
                echo '<h4> Total Users: '.$row.'</h4>';
            ?>
              </div>
            </div>
            <div class="col-auto">
              <i class="fa-solid fa-users fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Earnings (Monthly) Card Example -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-success shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total User Deposit</div>
              <?php
              //TOTAL DEPOSIT
              $sqldeposit = "SELECT SUM(amount) AS count FROM invest_plan WHERE type='deposit'";
              $duration_dep = $connection->query($sqldeposit);
              while ($record_dep = $duration_dep->fetch_assoc()) {
                  $total_dep = $record_dep[ 'count' ];
                    if ( empty( $total_dep ) ) {
                  $total_deposit = '0.00';
              } else {
                  $total_deposit = number_format( "$total_dep", 2 );
              }
              }

               ?>
              <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $currency ?><?php echo $total_deposit ?></div>
            </div>
            <div class="col-auto">
              <i class="fa-solid fa-download fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Earnings (Monthly) Card Example -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-info shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total User Withdrawal</div>
              <div class="row no-gutters align-items-center">
                <div class="col-auto">
                  <?php
                      //TOTAL WITHDRAWAL
                      $sqlsss = "SELECT SUM(transaction_amount) AS count FROM transaction WHERE transaction_type='withdrawal'";
                      $durationsss = $connection->query($sqlsss);
                      while ($recordsss = $durationsss->fetch_assoc()) {
                          $totalsss = $recordsss[ 'count' ];
                            if ( empty( $totalsss ) ) {
                          $total_withdrawal = '0.00';
                      } else {
                          $total_withdrawal = number_format( "$totalsss", 2 );
                      }
                      }
                   ?>
                  <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800"><?php echo $currency ?><?php echo $total_withdrawal ?></div>
                </div>
              </div>
            </div>
            <div class="col-auto">
              <i class="fa-solid fa-upload fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Investment calculation -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-success shadow h-100 py-2">
        <div class="card-body">
          <div class="row no-gutters align-items-center">
            <div class="col mr-2">
              <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Invested Amount</div>
              <?php
              //TOTAL DEPOSIT
              $sqlinvest = "SELECT SUM(amount) AS count FROM invest_plan";
              $duration_invest = $connection->query($sqlinvest);
              while ($record_invest = $duration_invest->fetch_assoc()) {
                  $total_invest = $record_invest[ 'count' ];
                    if ( empty( $total_invest ) ) {
                  $total_investment = '0.00';
              } else {
                  $total_investment = number_format( "$total_invest", 2 );
              }
              }

               ?>
              <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $currency ?><?php echo $total_investment ?></div>
            </div>
            <div class="col-auto">
              <i class="fa-solid fa-sack-dollar fa-2x text-gray-300"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
    
  </div>

  <!-- Content Row -->








  <?php
include('includes/scripts.php');
include('includes/footer.php');
?>
